/*
 * @(#)ScaleFactorConstraints.java  1.2  2002-02-06
 *
 * Copyright (c) 1999-2000 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * mailto:werner.randelshofer@bluewin.ch
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of 
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */
package ch.randelshofer.gui;

import java.awt.*;
/**
 * The ScaleFactorConstraints class specifies constraints for
 * components that are laid out using the ScaleFactorLayout class.
 *
 * @author  Werner Randelshofer, Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * @version 1.2 2002-02-06 'Scale to fit' property added.
 * <br>1.1 2000-09-27 Setter for factorX, factorY and maintainAspectRatio added.
 * <br>1.0.1   2000-06-12 Reworked.
 * <br>1.0  1999-10-19
 */
public class ScaleFactorConstraints {
    public double factorX = 1.0;
    public double factorY = 1.0;
    public boolean maintainAspectRatio = true;
    public boolean scaleToFit = true;

    /**
     * Creates a ScaleFactorConstraints object with all of its
     * set to the default values.
     */
    public ScaleFactorConstraints() {
    }

    /**
     * Creates a ScaleFactorConstraints object with all of its
     * fields set to the passed-in arguments.
     *
     * @param factorX   the scale factor for the x axis of the component.
     * @param factorY   the scale factor for the y axis of the component.
     * @param maintainAspectRatio   set to true if the aspect ratio of the
     *                  component shall be maintained.
     */
    public ScaleFactorConstraints(double factorX, double factorY, boolean maintainAspectRatio) {
        this.factorX = factorX;
        this.factorY = factorY;
        this.maintainAspectRatio = maintainAspectRatio;
    }

    public void setConstraints(double factorX, double factorY, boolean maintainAspectRatio) {
        this.factorX = factorX;
        this.factorY = factorY;
        this.maintainAspectRatio = maintainAspectRatio;
    }

    public double getFactorX() {
        return factorX;
    }

    public double getFactorY() {
        return factorY;
    }

    public void setFactorX(double d) {
        factorX = d;
    }

    public void setFactorY(double d) {
        factorY = d;
    }
    public boolean isMaintainAspectRatio() {
        return maintainAspectRatio;
    }
    public void setMaintainAspectRatio(boolean b) {
        maintainAspectRatio = b;
    }
    public boolean isScaleToFit() {
        return scaleToFit;
    }
    public void setScaleToFit(boolean b) {
        scaleToFit = b;
    }
}
